#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>

#define BROJ_VOZILA 10

pthread_mutex_t mutex;
pthread_cond_t cond;

int zauzeta_traka = 0; // 0 - slobodna traka, 1 - zauzeta traka
int zauzeo_kamion = 0; // 0 - kamion ne zauzima, 1 - kamion zauzima
int zauzeo_autobus = 0; // 0 - kamion ne zauzima, 1 - kamion zauzima
int dolasci_po_smeru[2] = {0, 0}; // [0] - smer A, [1] - smer B

void *posao(void *arg){
    long index = (long) arg;

    int smer = (rand() % 2) ? 0 : 1; // odredjivanje smera
    int kategorija = rand() % 3; // 0 - automobil, 1 - autobus, 2 - kamion 

    printf("[+] Vozilo %ld (kategorija %d) prilazi nadvoznjaku iz smera %d\n", index, kategorija, smer);
    sleep(rand() % 5); // simulacija dolaska vozila

    printf("[!] Vozilo %ld (kategorija %d) stiglo do nadvoznjaka iz smera %d\n", index, kategorija, smer);
    pthread_mutex_lock(&mutex);
    while(1){
        int suprotan_smer = 1 - smer; 

        // ako je nadvoznjak zauzet od strane vozila koja dolaze sa suprotne strane, stoj
        if(zauzeta_traka != 0 && dolasci_po_smeru[suprotan_smer] > 0){
            printf("[1] Vozilo %ld (kategorija %d) ceka prelaz vozila iz suprotnog smera\n", index, kategorija);
            pthread_cond_wait(&cond, &mutex);
            continue;
        }

        // ako je nadvoznjak zauzeo autobus, ako sam autobus ili kamion, stoj
        if(zauzeo_autobus != 0 && kategorija != 0){
            printf("[2] Vozilo %ld (kategorija %d) ceka prelaz autobusa\n", index, kategorija);
            pthread_cond_wait(&cond, &mutex);
            continue;
        }
        
        // ako je nadvoznjak zauzeo kamion, stoj        
        if(zauzeo_kamion != 0){
            printf("[3] Vozilo %ld (kategorija %d) ceka prelaz kamiona\n", index, kategorija);
            pthread_cond_wait(&cond, &mutex);
            continue;
        }

        break;
    }
    dolasci_po_smeru[smer]++;
    zauzeta_traka = 1;
    if(kategorija == 1) zauzeo_autobus = 1;
    if(kategorija == 2) zauzeo_kamion = 1;

    pthread_mutex_unlock(&mutex);

    printf("[*] Vozilo %ld (kategorija %d) uslo u nadvoznjak iz smera %d\n", index, kategorija, smer);
    if(kategorija == 1 || kategorija == 2){ 
        printf("=========================================================\n");
        sleep(5);
    }
    else sleep(3);

    pthread_mutex_lock(&mutex);
    printf("[-] Vozilo %ld (kategorija %d) je preslo preko nadvoznjaka iz smera %d\n", index, kategorija, smer);
    dolasci_po_smeru[smer]--;
    
    zauzeta_traka = 0;
    if(kategorija == 1) zauzeo_autobus = 0;
    if(kategorija == 2) zauzeo_kamion = 0;
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

int main(){
    pthread_t niti[BROJ_VOZILA];
    long i;

    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);
    for(i = 0; i < BROJ_VOZILA; i++) pthread_create(&niti[i], NULL, posao, (void *) i);

    for(i = 0; i < BROJ_VOZILA; i++) pthread_join(niti[i], NULL);
    return 0;
}